﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class NETSHelperBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static NETSHelper.TransactionResponse GetItem(Guid NETSTransactionID, Guid ordersPaymentID, string keyword)
        {
            return NETSHelperDB.GetItem(NETSTransactionID, ordersPaymentID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<NETSHelper.TransactionResponse> GetList(Guid NETSTransactionID, Guid ordersPaymentID, string keyword)
        {
            return NETSHelperDB.GetList(NETSTransactionID, ordersPaymentID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid NETSTransactionID, Guid ordersPaymentID, string keyword)
        {
            return NETSHelperDB.GetDataTable(NETSTransactionID, ordersPaymentID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid NETSTransactionID, Guid ordersPaymentID, string keyword)
        {
            return NETSHelperDB.GetDataSet(NETSTransactionID, ordersPaymentID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(AZVIC.Ei8htPOS.Entities.NETSHelper.TransactionResponse myOrdersDetails)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                NETSHelperDB.Save(myOrdersDetails);
                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
